function get_threshold(threshold, δs, r, K, s)
    if threshold == "GK16"
        βs = GK16.(δs);
    elseif threshold == "TT"
        βs = TT.(δs, r, K);
    elseif threshold == "FTT"
        βs = FTT.(δs, r, K);
    else
        @error threshold * ": not implemented"
    end
    βs;
end

# Threshold recommended by (Garivier and Kaufmann, 2016) and used extensively by subsequent publications.
struct GK16
    δ;
end

abbrev(β::GK16) = "GK16";

function (β::GK16)(t)
    log((log(t)+1)/β.δ)
end

# Theoretical threshold
struct TT
    δ;
    r; # rank identification
    K;
    TT(δ, r, K) = new(δ, r, K);
end

abbrev(β::TT) = "TT";

function (β::TT)(t)
    log((β.K - 1) / β.δ) + β.r * log(1 + t / β.r) + β.r;
end

# Family of theoretical thresholds
struct FTT
    δ;
    r; # rank identification
    K;
    FTT(δ, r, K) = new(δ, r, K);
end

abbrev(β::FTT) = "FTT";

function (β::FTT)(n1, n2)
    log((β.K - 1) / β.δ) + log(1 + n2) + log(1 + n1) + β.r;
end

function (β::FTT)(t)
    log((β.K - 1) / β.δ) + β.r * log(1 + t / β.r) + β.r;
end
